/*************************************************************************
 * The contents of this file are subject to the MYRICOM MYRINET          *
 * EXPRESS (MX) NETWORKING SOFTWARE AND DOCUMENTATION LICENSE (the       *
 * "License"); User may not use this file except in compliance with the  *
 * License.  The full text of the License can found in LICENSE.TXT       *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>

#include "mx_auto_config.h"
#include "myriexpress.h"
#include "mx_extensions.h"
#include "test_common.h"

int main(void)
{
  mx_endpoint_t ep;
  mx_endpoint_addr_t addr;
  char buff1[80];
  char buff2[80];
  mx_segment_t seg1;
  mx_segment_t seg2;
  mx_request_t req1;
  mx_request_t req2;
  mx_status_t status;
  mx_return_t ret;
  uint32_t result;
  uint64_t my_nic_id;
  uint32_t my_eid;

  mx_set_error_handler(MX_ERRORS_RETURN);

  ret = mx_init();
  insist(ret == MX_SUCCESS);
  ret = mx_open_endpoint(MX_ANY_NIC, MX_ANY_ENDPOINT, 0, NULL, 0, &ep);
  insist(ret == MX_SUCCESS);
  ret = mx_get_endpoint_addr(ep, &addr);
  insist(ret == MX_SUCCESS);
  ret = mx_decompose_endpoint_addr(addr, &my_nic_id, &my_eid);
  insist(ret == MX_SUCCESS);

  seg1.segment_ptr = buff1;
  seg1.segment_length = 80;
  seg2.segment_ptr = buff2;
  seg2.segment_length = 80;

  /* cancel irecv without matching send -- should succeed */
  printf("Cancelling unmatched receive...\n");
  ret = mx_irecv(ep, &seg2, 1, 10, MX_MATCH_MASK_NONE, NULL, &req2);
  insist(ret == MX_SUCCESS);
  ret = mx_cancel(ep, &req2, &result);
  insist(ret == MX_SUCCESS && result == 1);
  
  /* cancel irecv with matching send -- should fail */
  ret = mx_issend(ep, &seg1, 1, addr, 10, NULL, &req1);
  insist(ret == MX_SUCCESS);
  ret = mx_irecv(ep, &seg2, 1, 10, MX_MATCH_MASK_NONE, NULL, &req2);
  insist(ret == MX_SUCCESS);

  /* make sure the matching happens */
  sleep(1);
  mx_progress(ep);

  /* req1 already done */
  ret =  mx_wait(ep, &req1, 1000, &status, &result);
  insist((ret == MX_SUCCESS)
	 && (status.code == MX_STATUS_SUCCESS)
	 && (result == 1));

  /* req2 already done */
  printf("Trying to cancel completed receive...\n");
  ret = mx_cancel(ep, &req2, &result);
  insist(ret == MX_SUCCESS && !result);
  ret = mx_wait(ep, &req2, 1000, &status, &result);
  insist((ret == MX_SUCCESS)
	 && (status.code == MX_STATUS_SUCCESS)
	 && (result == 1));

  /* cancel iconnect before it progresses */
  mx_disable_progression(ep); /* large send will be queued */

  printf("Cancelling unprogressed iconnect...\n");
  ret = mx_iconnect(ep, my_nic_id, my_eid, 0, 10, NULL, &req2);
  insist(ret == MX_SUCCESS);
  ret = mx_cancel(ep, &req2, &result);
  insist(ret == MX_SUCCESS);
  if (!result) {
    ret =  mx_wait(ep, &req2, 1000, &status, &result);
    insist(ret == MX_SUCCESS && result);
    printf("** iconnect completed with progression disabled, self/shmem enabled?\n");
  }

  mx_reenable_progression(ep);

  printf("[SUCCESS]\n");

  mx_close_endpoint(ep);
  mx_finalize();
  return 0;
}
